import { StrapiImage } from '@/shared/ui/StrapiImage';
import { CtaBanner as ICtaBanner } from './model/interface';
import cn from 'classnames';
import RichText from '@/shared/ui/RichText';
import Button from '@/shared/ui/Button';
import './index.scss';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const CtaBanner = ({
  banner,
  mobileBanner,
  caption,
  description,
  link,
  title,
  lang,
  internalSectionTitle,
}: ICtaBanner) => {
  return (
    <section
      className="cta-banner"
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="cta-banner__container">
              <div className="cta-banner__content">
                {caption && (
                  <span className="cta-banner__caption typo-eyebrow">
                    {caption}
                  </span>
                )}
                {title && (
                  <div className="cta-banner__title">
                    <RichText text={title} />
                  </div>
                )}
                {description && (
                  <p className="cta-banner__description typo-body-1">
                    {description}
                  </p>
                )}
                {link?.title && (
                  <Button
                    size="lg"
                    border={!link?.url}
                    appearance={link.url ? 'dark' : 'transparent'}
                    href={link.url ? `/${lang}/${link.url}` : ''}
                    className={cn('cta-banner__link', { disabled: !link?.url })}
                  >
                    <span className="typo-link-big">{link.title}</span>
                  </Button>
                )}
              </div>
              <div className="cta-banner__img">
                <StrapiImage
                  img={banner}
                  className={cn({ 'd-lg-none-down': !!mobileBanner })}
                />
                {mobileBanner && (
                  <StrapiImage img={mobileBanner} className="d-lg-none-up" />
                )}
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CtaBanner;
