'use client';
import { useRef, useState } from 'react';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import type { Swiper as SwiperType } from 'swiper';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation } from 'swiper/modules';
import 'swiper/css';
import { CarouselCard } from '../../model/interface';

const Slider = ({ cards }: { cards: CarouselCard[] }) => {
  const nextElRef = useRef<HTMLDivElement>(null);
  const prevElRef = useRef<HTMLDivElement>(null);
  const [swiper, setSwiper] = useState<SwiperType | null>(null);

  const arrowIcon = (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="8"
      height="14"
      viewBox="0 0 8 14"
      fill="none"
    >
      <path
        d="M5.17198 6.99999L0.221985 2.04999L1.63598 0.635986L7.99998 6.99999L1.63598 13.364L0.221985 11.95L5.17198 6.99999Z"
        fill="white"
      />
    </svg>
  );

  return (
    <>
      <Swiper
        className="carousel__slider"
        slidesPerView={1}
        spaceBetween={8}
        onSwiper={setSwiper}
        modules={[Navigation]}
        navigation={{
          nextEl: nextElRef.current,
          prevEl: prevElRef.current,
        }}
        breakpoints={{
          1024: {
            slidesPerView: 'auto',
            spaceBetween: 16,
          },
        }}
      >
        {cards?.map(({ img, title }, index) => (
          <SwiperSlide className="carousel__slide" key={'cr' + title + index}>
            <div className="carousel-slide">
              <AspectRatio
                className="carousel-slide__img"
                width={386}
                height={448}
                mobileWidth={390}
                mobileHeight={492}
              >
                <StrapiImage img={img} />
              </AspectRatio>
              <p className="carousel-slide__description typo-head-5">{title}</p>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
      {cards.length && (
        <div className="carousel__buttons">
          <div className="button prev" ref={prevElRef}>
            {arrowIcon}
          </div>
          <div className="button next" ref={nextElRef}>
            {arrowIcon}
          </div>
        </div>
      )}
    </>
  );
};

export default Slider;
