import { DATA_SECTION_TITLE } from '@/app/lib/constants';
import './index.scss';

import { Carousel as ICarousel } from './model/interface';
import Slider from './ui/Slider/index';

const CarouselSlider = ({
  cards,
  title,
  description,
  sectionId,
  internalSectionTitle,
}: ICarousel) => {
  return (
    <section
      className="carousel"
      id={sectionId}
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-lg-8 offset-lg-2 col-12">
            <div className="carousel__container">
              <h3 className="carousel__title typo-head-5">
                {title}
                <span className="typo-head-5">{description}</span>
              </h3>
              <Slider cards={cards} />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CarouselSlider;
