import { getStrapiForm } from '@/app/lib/utils';
import RichText from '@/shared/ui/RichText';
import Steps from '../Steps';
import { CareersBanner as ICareersBanner } from './model/interface';
import './index.scss';

const CareersBanner = ({
  caption,
  title,
  description,
  formUid,
  defaultFormValues,
  lang,
}: ICareersBanner) => {
  const renderForm = async () => {
    try {
      const form = await getStrapiForm({ formUid: formUid!, lang });

      if (form.data[0]) {
        return (
          <Steps
            data={form.data[0].attributes}
            initFormValues={defaultFormValues || {}}
          />
        );
      } else {
        return <></>;
      }
    } catch (e) {}

    return <></>;
  };

  return (
    <section className="careers-banner">
      <div className="container">
        <div className="row">
          <div className="col-12 col-lg-10 offset-lg-1">
            <div className="careers-banner__container">
              <div className="careers-banner__text">
                {caption && (
                  <span className="careers-banner__caption typo-eyebrow">
                    {caption}
                  </span>
                )}
                {title && (
                  <div className="careers-banner__title">
                    <RichText text={title} />
                  </div>
                )}
                {description && (
                  <RichText
                    className="careers-banner__description"
                    text={description}
                  />
                )}
              </div>
              <div className="careers-banner__form">
                <div className="careers-banner__form-container">
                  {formUid && renderForm()}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CareersBanner;
