'use client';
import { useState } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import { EffectFade, Thumbs, Autoplay } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/effect-fade';

import './index.scss';

import { Brochures as IBrochures } from './model/interface';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';

const BrochureSlider = ({ brochures, sectionId }: IBrochures) => {
  const [thumbsSwiper, setThumbsSwiper] = useState(null);

  if (!brochures?.length) return null;

  return (
    <section className="brochure-slider" id={sectionId}>
      <div className="brochure-slider__images">
        <div className="brochure-slider__images-container">
          <Swiper
            slidesPerView={1}
            effect={'fade'}
            modules={[EffectFade]}
            onSwiper={(swiper: any) => setThumbsSwiper(swiper)}
            noSwipingClass={'brochure-slider__images'}
          >
            {brochures.map(({ img, description }, index) => (
              <SwiperSlide key={'br' + description + index}>
                <div className="brochure-slide">
                  <AspectRatio
                    width={390}
                    height={492}
                    className="brochure-slide__img"
                  >
                    <StrapiImage img={img} />
                  </AspectRatio>
                </div>
              </SwiperSlide>
            ))}
          </Swiper>
        </div>
      </div>

      <div className="container">
        <div className="row">
          <div className="col-12 col-lg-4">
            <Swiper
              className="brochure-slider__thumbs"
              thumbs={{ swiper: thumbsSwiper }}
              slidesPerView={1.2}
              modules={[Autoplay, Thumbs]}
              spaceBetween={16}
              autoplay={{ delay: 5000 }}
              breakpoints={{
                1024: {
                  slidesPerView: 'auto',
                  autoplay: { delay: 10000 },
                  slideToClickedSlide: true,
                },
              }}
            >
              {brochures.map(({ title, description }, index) => (
                <SwiperSlide key={'txt' + description + index}>
                  <div className="brochure-slide">
                    <div className="brochure-slide__info">
                      <span className="brochure-slide__title typo-head-5">
                        {title}
                      </span>
                      <span className="brochure-slide__description typo-body-2">
                        {description}
                      </span>
                    </div>
                  </div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        </div>
      </div>
    </section>
  );
};

export default BrochureSlider;
