import RichText from '@/shared/ui/RichText';
import './index.scss';

const BannerWithIframe = ({
  caption,
  title,
  description,
  iframeSrc,
  desktopTextMaxWidth,
  mobileTextMaxWidth,
}: {
  caption: string;
  title: string;
  description: string;
  iframeSrc: string;
  desktopTextMaxWidth: string;
  mobileTextMaxWidth: string;
}) => {
  const desktopMaxWidth = Number(desktopTextMaxWidth) || 500;
  const mobileMaxWidth = Number(desktopTextMaxWidth) || desktopMaxWidth;

  return (
    <section className="banner-with-iframe">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="banner-with-iframe__container">
              <div
                className="banner-with-iframe__text"
                style={
                  {
                    '--mobile-max-width': `${mobileMaxWidth}px`,
                    '--desktop-max-width': `${mobileMaxWidth}px`,
                  } as any
                }
              >
                {caption && (
                  <span className="banner-with-iframe__caption typo-eyebrow">
                    {caption}
                  </span>
                )}
                {title && (
                  <div className="banner-with-iframe__title">
                    <RichText text={title} />
                  </div>
                )}
                {description && (
                  <RichText
                    className="banner-with-iframe__description"
                    text={description}
                  />
                )}
              </div>
              {iframeSrc && (
                <div className="banner-with-iframe__iframe">
                  <div className="banner-with-iframe__iframe-container">
                    <iframe src={iframeSrc} width="100%" height="100%" />
                  </div>
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default BannerWithIframe;
