import { formatTime } from '@/app/lib/utils';
import SuggestedContent, {
  ISuggestedContent,
} from '@/shared/ui/SuggestedContent';
import './index.scss';

const ArticleSuggested = ({ items }: { items: ISuggestedContent[] }) => {
  return (
    <section className="article-suggested">
      <div className="article-suggested__container">
        {items?.map((item: ISuggestedContent) => (
          <SuggestedContent
            key={item.link}
            {...item}
            data={formatTime(item.data)}
          />
        ))}
      </div>
    </section>
  );
};

export default ArticleSuggested;
