'use client';

import { SocialItem } from '../../model/interface';

const ShareButton = ({ link, type }: SocialItem) => {
  const handleSocialClick = (link: string) => {
    const shareLink = link;
    const w = 500;
    const h = 600;

    const dualScreenLeft =
      window.screenLeft !== undefined ? window.screenLeft : window.screenX;
    const dualScreenTop =
      window.screenTop !== undefined ? window.screenTop : window.screenY;

    const width = window.innerWidth
      ? window.innerWidth
      : document.documentElement.clientWidth
      ? document.documentElement.clientWidth
      : screen.width;
    const height = window.innerHeight
      ? window.innerHeight
      : document.documentElement.clientHeight
      ? document.documentElement.clientHeight
      : screen.height;

    const systemZoom = 1;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft;
    const top = (height - h) / 2 / systemZoom + dualScreenTop;

    setTimeout(() => {
      window.open(
        shareLink,
        '_blank',
        `
              scrollbars=yes,
              width=${w / systemZoom}, 
              height=${h / systemZoom}, 
              top=${top}, 
              left=${left}
              `,
      );
    }, 0);
  };

  switch (type) {
    case 'fb':
      return (
        <button className="social-item" onClick={() => handleSocialClick(link)}>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="19"
            height="19"
            viewBox="0 0 19 19"
            fill="none"
          >
            <path
              d="M17 9.38867C17 5.24867 13.64 1.88867 9.5 1.88867C5.36 1.88867 2 5.24867 2 9.38867C2 13.0187 4.58 16.0412 8 16.7387V11.6387H6.5V9.38867H8V7.51367C8 6.06617 9.1775 4.88867 10.625 4.88867H12.5V7.13867H11C10.5875 7.13867 10.25 7.47617 10.25 7.88867V9.38867H12.5V11.6387H10.25V16.8512C14.0375 16.4762 17 13.2812 17 9.38867Z"
              fill="#1F1F1F"
            />
          </svg>
        </button>
      );
    case 'twitter':
      return (
        <button className="social-item" onClick={() => handleSocialClick(link)}>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="19"
            height="19"
            viewBox="0 0 19 19"
            fill="none"
          >
            <path
              d="M17.3443 4.88867C16.7668 5.15117 16.1443 5.32367 15.4993 5.40617C16.1593 5.00867 16.6693 4.37867 16.9093 3.62117C16.2868 3.99617 15.5968 4.25867 14.8693 4.40867C14.2768 3.76367 13.4443 3.38867 12.4993 3.38867C10.7368 3.38867 9.2968 4.82867 9.2968 6.60617C9.2968 6.86117 9.3268 7.10867 9.3793 7.34117C6.7093 7.20617 4.3318 5.92367 2.7493 3.98117C2.4718 4.45367 2.3143 5.00867 2.3143 5.59367C2.3143 6.71117 2.8768 7.70117 3.7468 8.26367C3.2143 8.26367 2.7193 8.11367 2.2843 7.88867V7.91117C2.2843 9.47117 3.3943 10.7762 4.8643 11.0687C4.39234 11.1978 3.89687 11.2158 3.4168 11.1212C3.6205 11.7605 4.01945 12.32 4.55756 12.7209C5.09567 13.1218 5.74588 13.3439 6.4168 13.3562C5.27952 14.2565 3.86979 14.7432 2.4193 14.7362C2.1643 14.7362 1.9093 14.7212 1.6543 14.6912C3.0793 15.6062 4.7743 16.1387 6.5893 16.1387C12.4993 16.1387 15.7468 11.2337 15.7468 6.98117C15.7468 6.83867 15.7468 6.70367 15.7393 6.56117C16.3693 6.11117 16.9093 5.54117 17.3443 4.88867Z"
              fill="#1F1F1F"
            />
          </svg>
        </button>
      );
    default:
      return (
        <button
          className="social-item"
          onClick={() => {
            if (navigator.clipboard) {
              navigator.clipboard.writeText(link);
            }
          }}
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="21"
            height="21"
            viewBox="0 0 21 21"
            fill="none"
          >
            <path
              d="M3.79658 9.87217C4.02992 8.64717 5.17992 7.8055 6.42992 7.8055H8.87158C9.30492 7.8055 9.66325 7.44717 9.66325 7.01383C9.66325 6.5805 9.30492 6.22217 8.87158 6.22217H6.51325C4.33825 6.22217 2.39658 7.81384 2.18825 9.9805C1.94658 12.4638 3.89658 14.5555 6.32992 14.5555H8.87158C9.30492 14.5555 9.66325 14.1972 9.66325 13.7638C9.66325 13.3305 9.30492 12.9722 8.87158 12.9722H6.32992C4.73825 12.9722 3.47992 11.5222 3.79658 9.87217ZM7.99658 11.2222H12.9966C13.4549 11.2222 13.8299 10.8472 13.8299 10.3888C13.8299 9.9305 13.4549 9.5555 12.9966 9.5555H7.99658C7.53825 9.5555 7.16325 9.9305 7.16325 10.3888C7.16325 10.8472 7.53825 11.2222 7.99658 11.2222ZM14.4799 6.22217H12.1216C11.6883 6.22217 11.3299 6.5805 11.3299 7.01383C11.3299 7.44717 11.6883 7.8055 12.1216 7.8055H14.5633C15.8133 7.8055 16.9633 8.64717 17.1966 9.87217C17.5133 11.5222 16.2549 12.9722 14.6633 12.9722H12.1216C11.6883 12.9722 11.3299 13.3305 11.3299 13.7638C11.3299 14.1972 11.6883 14.5555 12.1216 14.5555H14.6633C17.0966 14.5555 19.0466 12.4638 18.8133 9.9805C18.6049 7.81384 16.6549 6.22217 14.4799 6.22217Z"
              fill="#1F1F1F"
            />
          </svg>
        </button>
      );
  }
};

export default ShareButton;
