import Link from 'next/link';
import './index.scss';
import { SocialItem } from './model/interface';
import ShareButton from './ui/ShareButton';

const ArticleSharing = ({
  tags,
  translates,
  socialLinks,
}: {
  socialLinks: SocialItem[];
  tags: { title: string; url: string }[];
  translates: any;
}) => {
  return (
    <section className="article-sharing">
      <div className="article-sharing__container">
        <div className="article-sharing__tags">
          {tags?.map(({ title, url }) => (
            <Link key={url} href={url} className="tag-pill">
              <span className="typo-body-3">{title}</span>
            </Link>
          ))}
        </div>
        <div className="article-sharing__actions">
          <span className="typo-body-2">
            {translates?.newsPage?.shareThisOn || 'Share this on:'}
          </span>
          <div className="article-sharing__actions-buttons">
            {socialLinks.map(({ link, type }) => (
              <ShareButton key={link} link={link} type={type} />
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default ArticleSharing;
