import AspectRatio from '@/shared/ui/AspectRatio';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import Link from 'next/link';
import { OfferedItem as IOfferedItem } from '../../model/interface';
import './index.scss';

const OfferedItem = ({ img, title, url, caption }: IOfferedItem) => {
  return (
    <Link href={url} className="offered-item">
      <div className="offered-item__container">
        <AspectRatio
          height={261}
          width={411}
          mobileWidth={342}
          mobileHeight={261}
          className="offered-item__img"
        >
          <StrapiImage img={img} />
        </AspectRatio>

        <span className="offered-item__title typo-body-1-m">{title}</span>
        {caption && (
          <span className="offered-item__caption typo-body-3">{caption}</span>
        )}
      </div>
    </Link>
  );
};

export default OfferedItem;
