import { OfferedItem as IOfferedItem } from './model/interface';
import OfferedItem from './ui/OfferedItem';
import './index.scss';
import cn from 'classnames';

const ArticleOffered = ({ items }: { items: IOfferedItem[] }) => {
  return (
    <section className="article-offered">
      <div
        className={cn('article-offered__container', {
          'article-offered__container_single': items?.length === 1,
        })}
      >
        {items?.map((item) => (
          <OfferedItem key={item.url} {...item} />
        ))}
      </div>
    </section>
  );
};

export default ArticleOffered;
