'use client';
import { Play } from '@/app/assets/icons';
import AspectRatio from '@/shared/ui/AspectRatio';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import cn from 'classnames';
import dynamic from 'next/dynamic';
import { useState } from 'react';
import './index.scss';
import { ArticleMedia as IArticleMedia } from './model/interface';

const ReactPlayer = dynamic(() => import('react-player'), { ssr: false });

const ArticleMedia = ({ caption, images, video }: IArticleMedia) => {
  const [showVideoPoster, setShowVideoPoster] = useState(true);
  const [videoPlaying, setVideoPlaying] = useState(false);

  const playVideo = () => {
    if (!videoPlaying && showVideoPoster) {
      setVideoPlaying(true);
      setShowVideoPoster(false);
    }
  };

  return (
    <section className="article-media">
      <div className="article-media__container">
        {video?.url ? (
          <div className="article-media__video-content">
            <AspectRatio
              width={846}
              height={500}
              mobileWidth={390}
              mobileHeight={310}
            >
              {video?.url && (
                <div className="article-media__video-container">
                  <ReactPlayer
                    className="article-media__video"
                    url={video.url}
                    controls
                    width="100%"
                    height="100%"
                    playing={videoPlaying}
                  />
                  {showVideoPoster && (
                    <>
                      <StrapiImage
                        className="article-media__poster"
                        img={video.poster}
                      />
                      <button
                        className="article-media__video-button"
                        onClick={playVideo}
                      >
                        {Play}
                      </button>
                    </>
                  )}
                </div>
              )}
            </AspectRatio>
          </div>
        ) : (
          images?.length && (
            <div
              className={cn('article-media__images', {
                'article-media__images_single': images?.length === 1,
              })}
            >
              {images?.map((image) => (
                <div className={cn('article-media__img')} key={image.url}>
                  <StrapiImage img={image} />
                </div>
              ))}
            </div>
          )
        )}
        {caption && (
          <p className="article-media__caption typo-body-2">{caption}</p>
        )}
      </div>
    </section>
  );
};

export default ArticleMedia;
