'use client';
import { useRef, useState } from 'react';
import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';
import type { Swiper as SwiperType } from 'swiper';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation } from 'swiper/modules';
import 'swiper/css';
import { FeatureSlide } from '../../model/interface';

const Slider = ({ cards }: { cards: FeatureSlide[] }) => {
  const nextElRef = useRef<HTMLDivElement>(null);
  const prevElRef = useRef<HTMLDivElement>(null);
  const [swiper, setSwiper] = useState<SwiperType | null>(null);

  const arrowIcon = (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="8"
      height="14"
      viewBox="0 0 8 14"
      fill="none"
    >
      <path
        d="M5.17198 6.99999L0.221985 2.04999L1.63598 0.635986L7.99998 6.99999L1.63598 13.364L0.221985 11.95L5.17198 6.99999Z"
        fill="#06060E"
      />
    </svg>
  );

  return (
    <>
      <Swiper
        className="article-feature__slider"
        slidesPerView={1}
        spaceBetween={8}
        onSwiper={setSwiper}
        modules={[Navigation]}
        navigation={{
          nextEl: nextElRef.current,
          prevEl: prevElRef.current,
        }}
        breakpoints={{
          1024: {
            slidesPerView: 1.42,
          },
        }}
      >
        {cards?.map(({ img, title, description }, index) => (
          <SwiperSlide
            className="article-feature__slide"
            key={'cr' + title + index}
          >
            <div className="article-feature-slide">
              <AspectRatio
                className="article-feature-slide__img"
                width={600}
                height={450}
                mobileWidth={264}
                mobileHeight={310}
              >
                <StrapiImage img={img} />
              </AspectRatio>
              <p className="article-feature-slide__description typo-body-1-m">
                {title && `${title} `}
                <span className="article-feature-slide__description_second typo-body-1">
                  {description}
                </span>
              </p>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
      {cards.length && (
        <div className="article-feature__buttons">
          <div className="button prev" ref={prevElRef}>
            {arrowIcon}
          </div>
          <div className="button next" ref={nextElRef}>
            {arrowIcon}
          </div>
        </div>
      )}
    </>
  );
};

export default Slider;
