import { formatTime } from '@/app/lib/utils';
import AspectRatio from '@/shared/ui/AspectRatio';
import RichText from '@/shared/ui/RichText';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import cn from 'classnames';
import './index.scss';

const ArticleBanner = ({ data, title, subtitle, img, mobileImg }: any) => {
  return (
    <section className="article-banner">
      <div className="article-banner__content">
        <span className="article-banner__data typo-eyebrow">
          {formatTime(data)}
        </span>
        <RichText className="article-banner__title" text={title} />
        <p className="article-banner__subtitle typo-body-2">{subtitle}</p>

        <div className="article-banner__img">
          <AspectRatio
            width={846}
            height={500}
            mobileWidth={390}
            mobileHeight={310}
          >
            <StrapiImage
              alt={title}
              img={img}
              className={cn({ 'd-lg-none-down': !!mobileImg })}
            />
            {mobileImg && (
              <StrapiImage
                alt={title}
                img={mobileImg}
                className="d-lg-none-up"
              />
            )}
          </AspectRatio>
        </div>
      </div>
    </section>
  );
};

export default ArticleBanner;
