import { getStrapiForm } from '@/app/lib/utils';
import ClientButton from '@/shared/ui/ClientButton';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import Steps from '@/widgets/Steps';
import Link from 'next/link';
import { Advantage, AdvantageItemLink } from '../../model/interface';
import './index.scss';

const AdvantageItem = ({
  title,
  icon,
  link,
  rawIcon,
  description,
  lang,
}: Advantage) => {
  const content = !rawIcon ? (
    <div className="advantage-item__icon">
      {icon && <StrapiImage img={icon} />}
    </div>
  ) : (
    <div
      className="advantage-item__icon"
      dangerouslySetInnerHTML={{ __html: rawIcon }}
    />
  );

  const renderButton = async ({
    url,
    formUid,
    text,
    formDefaultValues,
  }: AdvantageItemLink) => {
    const isLocation = url === 'location';
    if (formUid || isLocation) {
      let formData;

      if (formUid) {
        try {
          const form = await getStrapiForm({ formUid, lang });

          formData = form.data[0].attributes;
        } catch (e) {}
      }

      return (
        <ClientButton
          trigger={
            <Link
              className="advantage-item__link typo-link-sm"
              href={url || ''}
            >
              {text}
            </Link>
          }
          render={
            formData && (
              <Steps data={formData} initFormValues={formDefaultValues} />
            )
          }
          formUid={formUid || ''}
          instruction={isLocation ? 'location' : 'form'}
        />
      );
    } else {
      return (
        <Link
          className="advantage-item__link typo-link-sm"
          href={`/${lang}/${url}` || ''}
        >
          {text}
        </Link>
      );
    }
  };

  return (
    <div className="advantage-item">
      <div className="advantage-item__container">
        {content}
        <div className="advantage-item__content">
          <div className="advantage-item__text">
            <span className="advantage-item__title typo-head-4">{title}</span>
            <span className="advantage-item__description typo-body-2">
              {description}
            </span>
          </div>
          <>{link && renderButton(link)}</>
        </div>
      </div>
    </div>
  );
};

export default AdvantageItem;
