import AspectRatio from '@/shared/ui/AspectRatio';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import { Advantages as IAdvantages } from './model/interface';
import cn from 'classnames';
import AdvantageItem from './ui/AdvantageItem';
import './index.scss';
import RichText from '@/shared/ui/RichText';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const Advantages = ({
  title,
  description,
  banner,
  mobileBanner,
  items,
  lang,
  internalSectionTitle,
}: IAdvantages) => {
  return (
    <section
      className="advantages"
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="advantages__container">
              <div className="advantages__header">
                <div className="advantages__title">
                  {title && <RichText text={title} />}
                </div>
                {description && (
                  <p className="advantages__description typo-body-1">
                    {description}
                  </p>
                )}
              </div>
              <AspectRatio
                className="advantages__banner"
                width={1280}
                height={539}
                mobileWidth={326}
                mobileHeight={259}
              >
                <StrapiImage
                  alt={title}
                  img={banner}
                  className={cn({ 'd-lg-none-down': !!mobileBanner })}
                />
                {mobileBanner && (
                  <StrapiImage
                    alt={title}
                    img={mobileBanner}
                    className="d-lg-none-up"
                  />
                )}
              </AspectRatio>
              <div className="advantages__items">
                {items?.map((item, index) => (
                  <AdvantageItem {...item} key={`ai${index}`} lang={lang} />
                ))}
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Advantages;
