import { IAboutNumbersItem } from '../../model/interface';

import './index.scss';

const Item = ({ title, value, description }: IAboutNumbersItem) => {
  return (
    <div className="about-numbers-item">
      {value && (
        <span className="about-numbers-item__value typo-head-0">{value}</span>
      )}
      {title && (
        <h3 className="about-numbers-item__title typo-head-3">{title}</h3>
      )}
      {description && (
        <p className="about-numbers-item__description typo-body-1">
          {description}
        </p>
      )}
    </div>
  );
};

export default Item;
