import Item from './ui/Item';

import { IAboutNumbers } from './model/interface';

import './index.scss';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const AboutNumbers = ({
  title,
  items,
  internalSectionTitle,
}: IAboutNumbers) => {
  return (
    <section
      className="about-numbers"
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container">
        <div className="row">
          <div className="col-12">
            {title && (
              <h2 className="about-numbers__title typo-head-2">{title}</h2>
            )}
            {items && (
              <div className="about-numbers__items">
                {items.map((item, index) => (
                  <Item
                    key={index}
                    title={item?.title}
                    value={item?.value}
                    description={item?.description}
                  />
                ))}
              </div>
            )}
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutNumbers;
