import { IAboutDiscover } from './model/interface';

import './index.scss';
import AspectRatio from '@/shared/ui/AspectRatio';
import { StrapiImage } from '@/shared/ui/StrapiImage';
import RichText from '@/shared/ui/RichText';
import { DATA_SECTION_TITLE } from '@/app/lib/constants';

const AboutDiscover = ({
  title,
  description,
  items,
  image,
  internalSectionTitle,
}: IAboutDiscover) => {
  return (
    <section
      className="about-discover"
      {...(internalSectionTitle
        ? { [DATA_SECTION_TITLE]: internalSectionTitle }
        : {})}
    >
      <div className="container about-discover__container">
        <div className="row">
          <div className="col-lg-8 offset-lg-4 col-12">
            <div className="about-discover__text">
              {title && (
                <h2 className="about-discover__title typo-head-0">{title}</h2>
              )}
              {description && (
                <p className="about-discover__description typo-body-1">
                  {description}
                </p>
              )}
            </div>
          </div>
          <div className="col-12">
            {items && (
              <div className="about-discover__items">
                {items.map(({ text }, index) => (
                  <div key={index} className="about-discover__item">
                    {text && (
                      <RichText
                        className="about-discover__item-text"
                        text={text}
                      />
                    )}
                  </div>
                ))}
              </div>
            )}
          </div>
          <div className="col-12">
            {image && (
              <AspectRatio
                width={1280}
                height={503}
                mobileWidth={341}
                mobileHeight={205}
              >
                <StrapiImage img={image} />
              </AspectRatio>
            )}
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutDiscover;
