'use client';

import React, { useState, useRef } from 'react';
import dynamic from 'next/dynamic';

import { Play } from '@/app/assets/icons';

import { StrapiImage } from '@/shared/ui/StrapiImage/index';
import AspectRatio from '@/shared/ui/AspectRatio/index';

import { IAboutBanner } from './model/interface';
import cn from 'classnames';

import './index.scss';

const ReactPlayer = dynamic(() => import('react-player'), { ssr: false });

const AboutBanner = ({
  title,
  subtitle,
  description,
  image,
  mobileImage,
  video,
}: IAboutBanner) => {
  const [showVideoPoster, setShowVideoPoster] = useState(true);
  const [videoPlaying, setVideoPlaying] = useState(false);

  const playVideo = () => {
    if (!videoPlaying && showVideoPoster) {
      setVideoPlaying(true);
      setShowVideoPoster(false);
    }
  };

  const imageContent = (className?: string) =>
    image && (
      <>
        <StrapiImage
          img={image}
          className={cn(className, { 'd-lg-none-down': !!mobileImage })}
        />
        {mobileImage && (
          <StrapiImage
            alt={title}
            img={mobileImage}
            className={cn(className, 'd-lg-none-up')}
          />
        )}
      </>
    );

  return (
    <section className="about-banner">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="about-banner__text">
              {subtitle && (
                <h5 className="typo-head-5 about__subtitle">{subtitle}</h5>
              )}
              {title && <h1 className="typo-head-1 about__title">{title}</h1>}
              {description && (
                <p className="typo-body-1 about__description">{description}</p>
              )}
            </div>
            {(video?.url || image) && (
              <div className="about-banner__media">
                <AspectRatio
                  width={1440}
                  height={609}
                  mobileWidth={390}
                  mobileHeight={310}
                >
                  {imageContent()}
                  {video?.url && (
                    <div className="about-banner__video-container">
                      <ReactPlayer
                        className="about-banner__video"
                        url={video.url}
                        controls
                        width="100%"
                        height="100%"
                        playing={videoPlaying}
                      />
                      {showVideoPoster && (
                        <>
                          {imageContent('about-banner__poster')}
                          <button
                            className="about-banner__video-button"
                            onClick={playVideo}
                          >
                            {Play}
                          </button>
                        </>
                      )}
                    </div>
                  )}
                </AspectRatio>
              </div>
            )}
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutBanner;
