import './index.scss';
import NextLink from 'next/link';
import { Arrow } from '@icons';
import { StrapiImage, StrapiImageInterface } from '../StrapiImage';
import cn from 'classnames';

export interface ISuggestedContent {
  link: string;
  className?: string;
  img: StrapiImageInterface;
  data: string;
  text: string;
  description?: string;
}

const SuggestedContent = ({
  link,
  data,
  img,
  text,
  className,
}: ISuggestedContent) => {
  return (
    <NextLink href={link} className={cn('suggested-content', className)}>
      <div className="suggested-content__container">
        <div className="suggested-content__img">
          <StrapiImage img={img} />
        </div>
        <div className="suggested-content__text">
          <span className="suggested-content__data typo-body-2">{data}</span>
          <span className="suggested-content__title typo-body-1-m">{text}</span>
        </div>
        <div className="suggested-content__arrow">{Arrow}</div>
      </div>
    </NextLink>
  );
};

export default SuggestedContent;
