import Image from 'next/image';
import { getStrapiMedia } from '@lib/utils';
import ClientImage from './ClientImage';

interface ImageProps {
  name: string;
  hash: string;
  ext: string;
  mime: string;
  width: number;
  height: number;
  size: number;
  url: string;
}

interface ImageFormat extends ImageProps {
  sizeInBytes?: number;
  path?: string;
}

export interface StrapiImageInterface extends ImageProps {
  alternativeText: string;
  caption: string;
  previewUrl: null;
  provider: string;
  provider_metadata: null;
  folderPath: string;
  createdAt: string;
  updatedAt: string;
  formats: {
    [key: string]: ImageFormat;
  };
}

export interface StrapiImageProps {
  img: StrapiImageInterface;
  alt?: string;
  className?: string;
  loading?: 'lazy' | 'eager';
}

export function StrapiImage({
  img,
  alt = '',
  className,
  loading = 'lazy',
}: Readonly<StrapiImageProps>) {
  const src = img?.url;
  if (!src) return null;

  const isLazy = loading === 'lazy';

  const imageComponent = (
    <Image
      className={className}
      alt={img.name || alt || 'Image'}
      src={getStrapiMedia(img.url)!}
      width={img.width}
      loading={loading}
      height={img.height}
    />
  );

  return (
    <>
      {isLazy ? (
        <>
          <ClientImage img={img} alt={alt} className={className} />
          <noscript>{imageComponent}</noscript>
        </>
      ) : (
        imageComponent
      )}
    </>
  );
}
