'use client';
import './index.scss';
import { getStrapiMedia } from '@/app/lib/utils';
import { useEffect, useRef } from 'react';
import { StrapiImageProps } from '.';
import cn from 'classnames';

const ClientImage = ({
  img,
  alt = '',
  className,
}: Readonly<StrapiImageProps>) => {
  const srcSet = Object.values(img.formats || {})
    .map((format) => `${getStrapiMedia(format.url)} ${format.width}w`)
    .join(', ');

  const fullSrcSet = `${srcSet}, ${getStrapiMedia(img.url)} ${img.width}w`;

  const maxWidth = Math.max(
    ...Object.values(img.formats || {}).map((format) => format.width),
    img.width,
  );

  const sizes = `(max-width: ${maxWidth}px) 100vw, ${maxWidth}px`;

  const imageRef = useRef(null);

  useEffect(() => {
    const img = imageRef.current;

    const observer = new IntersectionObserver(
      (entries, observer) => {
        entries.forEach((entry) => {
          //@ts-ignore

          if (entry.isIntersecting) {
            const lazyImage = entry.target;
            //@ts-ignore
            lazyImage.srcset = lazyImage.dataset.srcset;
            observer.unobserve(lazyImage);
          }
        });
      },
      { threshold: 0.15 },
    );

    if (img) {
      observer.observe(img);
    }

    return () => {
      if (img) observer.unobserve(img);
    };
  }, []);

  return (
    <img
      ref={imageRef}
      className={cn(className, 'loading')}
      data-src={getStrapiMedia(img.url)!}
      alt={img.name || alt || 'Image'}
      data-srcset={fullSrcSet}
      sizes={sizes}
      width={img.width}
      height={img.height}
      onLoad={(e: any) => {
        e.target.classList.add('loaded');
      }}
    />
  );
};

export default ClientImage;
