import { getStrapiForm } from '@/app/lib/utils';
import Steps from '@/widgets/Steps';
import ArrowLink from '../ArrowLink';
import Button from '../Button';
import ClientButton from '../ClientButton';
import { StrapiButton as IStrapiButton } from './model/interface';

const StrapiButton = ({
  className,
  button,
  lang,
}: {
  button: IStrapiButton;
  lang: string;
  className?: string;
}) => {
  const {
    appearance,
    text,
    formDefaultValues,
    formUid,
    url,
    behavior,
    buttonSize,
    hasBorder,
    hiddenFormFields,
    download,
  } = button;

  const computedClassName = `${
    buttonSize === 'sm' ? 'typo-link-sm' : 'typo-link-big'
  } ${className}`;

  const renderButton = async () => {
    const isLocation = url === 'location';
    if (formUid || isLocation) {
      let formData;

      if (formUid) {
        try {
          const form = await getStrapiForm({ formUid, lang });

          formData = form.data[0].attributes;
        } catch (e) {}
      }

      return (
        <ClientButton
          trigger={
            behavior === 'link' ? (
              <ArrowLink
                className={computedClassName}
                href={url}
                download={download}
              >
                {text}
              </ArrowLink>
            ) : (
              <Button
                className={computedClassName}
                appearance={appearance}
                size={buttonSize}
                border={hasBorder}
              >
                {text}
              </Button>
            )
          }
          render={
            formData && (
              <Steps
                data={formData}
                initFormValues={formDefaultValues}
                hiddenFormFields={{
                  ...hiddenFormFields,
                  ...(formUid === 'download-brochure-form' && download
                    ? { fileUrl: url }
                    : {}),
                }}
                downloadUrl={download && url}
              />
            )
          }
          instruction={isLocation ? 'location' : 'form'}
          formUid={formUid || ''}
        />
      );
    } else {
      return behavior === 'link' ? (
        <ArrowLink
          className={computedClassName}
          href={download ? url : `/${lang}/${url}`}
          download={download}
        >
          {text}
        </ArrowLink>
      ) : (
        <Button
          className={computedClassName}
          appearance={appearance}
          size={buttonSize}
          href={`/${lang}/${url}`}
          border={hasBorder}
        >
          {text}
        </Button>
      );
    }
  };

  return <>{renderButton()}</>;
};

export default StrapiButton;
