'use client';
import { PropsWithChildren } from 'react';
import React, { useState, useEffect, useRef } from 'react';

const StickyContent = ({
  children,
  disabledSticky,
}: PropsWithChildren<{ disabledSticky?: boolean }>) => {
  const [isSticky, setIsSticky] = useState(false);
  const [lastScrollPos, setLastScrollPos] = useState(0);
  const [placeholderHeight, setPlaceholderHeight] = useState(0);
  const containerRef = useRef(null);
  const placeholderRef = useRef(null);

  const updatePlaceholderHeight = () => {
    if (containerRef.current) {
      //@ts-ignore
      setPlaceholderHeight(containerRef.current.offsetHeight);
    }
  };
  const handleScroll = () => {
    if (!placeholderRef.current) return;

    const container = placeholderRef.current;
    //@ts-ignore
    const containerRect = container.getBoundingClientRect();
    if (containerRect.bottom > window.innerHeight) {
      setIsSticky(false);
    } else if (containerRect.bottom <= window.innerHeight) {
      setIsSticky(true);
    }
  };

  useEffect(() => {
    window.addEventListener('scroll', handleScroll);

    return () => {
      window.removeEventListener('scroll', handleScroll);
    };
  }, [lastScrollPos]);

  const handleResize = () => {
    handleScroll();
    updatePlaceholderHeight();
  };

  useEffect(() => {
    handleResize();

    window.addEventListener('resize', handleResize);

    return () => {
      window.removeEventListener('resize', handleResize);
    };
  }, []);

  if (disabledSticky) {
    return <>{children}</>;
  }

  return (
    <div
      style={{
        position: 'relative',
      }}
    >
      <div
        ref={placeholderRef}
        style={{
          height: placeholderHeight,
          position: 'relative',
        }}
      ></div>

      <div
        ref={containerRef}
        style={{
          position: isSticky ? 'fixed' : 'absolute',
          bottom: 0,
          left: 0,
          width: '100%',
          zIndex: 100,
        }}
      >
        {isSticky ? (
          <div className="container">
            <div className="row">
              <div className="col-12">{children}</div>
            </div>
          </div>
        ) : (
          <>{children}</>
        )}
      </div>
    </div>
  );
};

export default StickyContent;
