import { ChangeEvent, forwardRef, useState } from 'react';
import './index.scss';

interface IInput {
  label?: string;
  placeholder?: string;
  error?: string;
  value?: string;
  name: string;
  hint?: string;
  onSearchClick: (value: string) => void;
  onChange?: (e: ChangeEvent<HTMLInputElement>) => void;
  onBlur?: (e: ChangeEvent<HTMLInputElement>) => void;
}

const SearchInput = forwardRef<HTMLInputElement, IInput>(
  (
    {
      label = '',
      placeholder = '',
      error = '',
      value,
      name,
      hint,
      onSearchClick,
      onChange = () => {},
      onBlur = () => {},
    },
    ref,
  ) => {
    const [inputValue, setInputValue] = useState(value || '');
    return (
      <div className="search-input">
        <div className="search-input__container">
          {label && (
            <label className="search-input__label typo-body-3">{label}</label>
          )}
          <div className="search-input__content">
            <div
              className="search-input__icon"
              onClick={() => onSearchClick(inputValue)}
            >
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="16"
                height="16"
                viewBox="0 0 16 16"
                fill="none"
              >
                <path
                  d="M12.0233 11.2345L15.2355 14.446L14.1742 15.5072L10.9628 12.295C9.7678 13.2529 8.2815 13.7739 6.75 13.7717C3.024 13.7717 0 10.7477 0 7.02173C0 3.29573 3.024 0.271729 6.75 0.271729C10.476 0.271729 13.5 3.29573 13.5 7.02173C13.5022 8.55323 12.9812 10.0395 12.0233 11.2345ZM10.5187 10.678C11.4706 9.69914 12.0022 8.38705 12 7.02173C12 4.12073 9.65025 1.77173 6.75 1.77173C3.849 1.77173 1.5 4.12073 1.5 7.02173C1.5 9.92198 3.849 12.2717 6.75 12.2717C8.11532 12.2739 9.42741 11.7423 10.4062 10.7905L10.5187 10.678Z"
                  fill="#818387"
                />
              </svg>
            </div>
            <input
              ref={ref}
              type="text"
              className="typo-body-1-m"
              onChange={(e) => {
                setInputValue(e.target.value);
                onChange(e);
              }}
              onKeyUp={(e) => {
                if (e.key === 'Enter') {
                  onSearchClick(inputValue);
                }
              }}
              onBlur={onBlur}
              placeholder={placeholder}
              value={inputValue}
              autoComplete={'dsbld'}
              name={name}
            />
          </div>

          {hint && (
            <span className="search-input__hint typo-body-3">{hint}</span>
          )}
          {error && (
            <span className="search-input__error typo-body-3">{error}</span>
          )}
        </div>
      </div>
    );
  },
);
SearchInput.displayName = 'SearchInput';
export default SearchInput;
