import Markdown from 'react-markdown';
import remarkGfm from 'remark-gfm';
import cn from 'classnames';
import './index.scss';

const RichText = ({
  className,
  text,
  useMakeLinksExternal = false,
}: {
  className?: string;
  text: string;
  useMakeLinksExternal?: boolean;
}) => {
  return (
    <Markdown
      className={cn('rich-text-markdown', className)}
      components={
        useMakeLinksExternal
          ? {
              a: (props: any) => (
                <a href={props.href} target="_blank" rel="noreferrer">
                  {props.children}
                </a>
              ),
            }
          : {}
      }
      remarkPlugins={[remarkGfm]}
    >
      {text}
    </Markdown>
  );
};

export default RichText;
