import './index.scss';
import { InputMask, type MaskEventDetail } from '@react-input/mask';
import { ChangeEvent, useState } from 'react';

interface IPhoneInput {
  label?: string;
  placeholder?: string;
  value?: string;
  error?: string;
  hint?: string;
  mask: string;
  onChange: (value: string) => void;
  onBlur?: (value: string) => void;
}
const MASK_CHAR = 'X';

const PhoneInput = ({
  mask,
  onChange,
  label,
  placeholder,
  error,
  hint,
  value: defaultValue,
  onBlur = () => {},
}: IPhoneInput) => {
  const [value, setValue] = useState(defaultValue || mask);
  const [detail, setDetail] = useState<MaskEventDetail | null>(null);

  const handleValueChange = (detail: MaskEventDetail) => {
    const value = detail.value;
    setValue(value);
    setDetail(detail);

    if (detail.isValid) {
      onChange(detail.value);
    } else {
      onChange('');
    }
  };

  return (
    <div className="phone">
      <div className="phone__container">
        {label && <label className="phone__label typo-body-3">{label}</label>}
        <div className="phone__content">
          <div className="phone__country">
            <div className="phone__country-icon">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="20"
                height="21"
                viewBox="0 0 20 21"
                fill="none"
              >
                <path
                  d="M10 20.0225C15.5228 20.0225 20 15.5453 20 10.0225C20 4.49961 15.5228 0.0224609 10 0.0224609C4.47715 0.0224609 0 4.49961 0 10.0225C0 15.5453 4.47715 20.0225 10 20.0225Z"
                  fill="#13713C"
                />
                <path
                  d="M5.65234 11.9795C5.65234 12.6998 6.23633 13.2838 6.95668 13.2838H10.8697C10.8697 13.8841 11.3564 14.3708 11.9567 14.3708H13.261C13.8613 14.3708 14.348 13.8841 14.348 13.2838V11.9795H5.65234Z"
                  fill="#F0F0F0"
                />
                <path
                  d="M14.4565 5.6748V8.71828C14.4565 9.19777 14.0664 9.58785 13.5869 9.58785V10.8922C14.7856 10.8922 15.7608 9.91695 15.7608 8.71828V5.6748H14.4565Z"
                  fill="#F0F0F0"
                />
                <path
                  d="M5.10883 8.71828C5.10883 9.19777 4.71875 9.58785 4.23926 9.58785V10.8922C5.43797 10.8922 6.41316 9.91695 6.41316 8.71828V5.6748H5.10883V8.71828Z"
                  fill="#F0F0F0"
                />
                <path
                  d="M12.5 5.6748H13.8043V8.71828H12.5V5.6748Z"
                  fill="#F0F0F0"
                />
                <path
                  d="M10.5437 7.41394C10.5437 7.53383 10.4461 7.63133 10.3263 7.63133C10.2064 7.63133 10.1089 7.53379 10.1089 7.41394V5.6748H8.80457V7.41394C8.80457 7.53383 8.70703 7.63133 8.58719 7.63133C8.46734 7.63133 8.3698 7.53379 8.3698 7.41394V5.6748H7.06543V7.41394C7.06543 8.25305 7.74809 8.9357 8.58719 8.9357C8.91035 8.9357 9.21004 8.83414 9.45676 8.66164C9.70344 8.8341 10.0032 8.9357 10.3263 8.9357C10.3914 8.9357 10.4554 8.93113 10.5183 8.92312C10.4259 9.30395 10.0829 9.58785 9.67414 9.58785V10.8922C10.8729 10.8922 11.848 9.91695 11.848 8.71828V7.41394V5.6748H10.5437V7.41394H10.5437Z"
                  fill="#F0F0F0"
                />
                <path
                  d="M7.06543 9.58789H9.02195V10.8922H7.06543V9.58789Z"
                  fill="#F0F0F0"
                />
              </svg>
            </div>
            <span className="phone__country-code typo-body-1-m">+966</span>
          </div>

          <InputMask
            className="phone__input typo-body-1-m"
            autoComplete="dsbld"
            mask={mask}
            replacement={{ [MASK_CHAR]: /\d/ }}
            placeholder={placeholder}
            showMask={true}
            value={value}
            type={'tel'}
            onMask={(event: any) => handleValueChange(event.detail)}
            onBlur={() => detail && onBlur(detail.isValid ? detail.value : '')}
          />
        </div>
        {hint && <span className="phone__hint typo-body-3">{hint}</span>}
        {error && <span className="phone__error typo-body-3">{error}</span>}
      </div>
    </div>
  );
};

export default PhoneInput;
