import { Arrow } from '@/app/assets/icons';
import { PAGE_KEY } from '@/app/lib/constants';
import Link from 'next/link';
import './index.scss';

const Pagination = ({
  currentPage,
  totalPages,
  prefix,
  searchParams,
}: {
  currentPage: number;
  totalPages: number;
  prefix: string;
  searchParams: any;
}) => {
  const generatePageNumbers = (current: number, total: number) => {
    const range = (start: number, end: number) =>
      Array.from({ length: end - start + 1 }, (_, i) => start + i);
    if (total <= 5) return range(1, total);

    if (current <= 3) return [...range(1, 4), '...', total];

    if (current >= total - 2) return [1, '...', ...range(total - 3, total)];

    return [1, '...', current - 1, current, current + 1, '...', total];
  };

  const renderPagination = () => {
    return generatePageNumbers(currentPage, totalPages).map((item) =>
      item === '...' ? (
        <span key={item} className="pagination-page pagination-page_nothing">
          {item}
        </span>
      ) : item === currentPage ? (
        <span key={item} className="pagination-page pagination-page_active">
          {`${item}`.padStart(2, '0')}
        </span>
      ) : (
        <Link
          key={item}
          href={{
            pathname: prefix,
            query: { ...searchParams, [PAGE_KEY]: item },
          }}
          className="pagination-page"
        >
          {`${item}`.padStart(2, '0')}
        </Link>
      ),
    );
  };

  return (
    <div className="pagination">
      {currentPage > 1 ? (
        <Link
          key="prev"
          className="pagination__prev"
          href={{
            pathname: prefix,
            query: { ...searchParams, [PAGE_KEY]: currentPage - 1 },
          }}
        >
          {Arrow}
        </Link>
      ) : (
        <span
          key={'prev'}
          className="pagination__prev pagination__prev_disabled"
        >
          {Arrow}
        </span>
      )}

      <div className="pagination__pages">{renderPagination()}</div>

      {currentPage < totalPages ? (
        <Link
          key="next"
          className="pagination__next"
          href={{
            pathname: prefix,
            query: { ...searchParams, [PAGE_KEY]: currentPage + 1 },
          }}
        >
          {Arrow}
        </Link>
      ) : (
        <span
          key={'next'}
          className="pagination__next pagination__next_disabled"
        >
          {Arrow}
        </span>
      )}
    </div>
  );
};

export default Pagination;
