import { useRef, useState } from 'react';
import VerificationInput from 'react-verification-input';
import './index.scss';

interface IOtpInput {
  onChange: (value: string) => void;
  length: number;
  label?: string;
  hint?: string;
  error?: string;
  value?: string;
  onBlur?: (value: string) => void;
}

const OtpInput = ({
  label,
  hint,
  error,
  value,
  onChange,
  length = 4,
  onBlur = () => {},
}: IOtpInput) => {
  const verificationInputRef = useRef<HTMLInputElement>(null);
  const [verificationValue, setVerificationValue] = useState<string>(
    value || '',
  );

  const handleVerificationInputChange = (value: string) => {
    setVerificationValue(value);

    if (length === value.length) {
      onChange(value);
    } else {
      onChange('');
    }
  };

  return (
    <div className="otp">
      <div className="otp__container">
        {label && <label className="otp__label typo-body-3">{label}</label>}
        <VerificationInput
          ref={verificationInputRef}
          value={verificationValue}
          length={length}
          classNames={{
            container: 'otp-input',
            character: 'otp-input__character',
            characterSelected: 'otp-input__character_selected',
          }}
          placeholder=""
          autoFocus
          inputProps={{ autoComplete: 'one-time-code' }}
          onChange={handleVerificationInputChange}
        />
        {hint && <span className="input__hint typo-body-3">{hint}</span>}
        {error && <span className="input__error typo-body-3">{error}</span>}
      </div>
    </div>
  );
};

export default OtpInput;
