import { ChangeEvent, forwardRef, useState } from 'react';
import './index.scss';

interface IInput {
  label?: string;
  placeholder?: string;
  error?: string;
  value?: string;
  name: string;
  hint?: string;
  type?: 'input' | 'textarea';
  maxLength?: number;
  onChange?: (e: ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => void;
  onBlur?: (e: ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => void;
}

const Input = forwardRef<HTMLInputElement & HTMLTextAreaElement, IInput>(
  (
    {
      type = 'input',
      label = '',
      placeholder = '',
      error = '',
      value,
      name,
      hint,
      maxLength,
      onChange = () => {},
      onBlur = () => {},
    },
    ref,
  ) => {
    const [inputValue, setInputValue] = useState(value);
    return (
      <div className="input">
        <div className="input__container">
          {label && <label className="input__label typo-body-3">{label}</label>}
          {type === 'textarea' ? (
            <textarea
              ref={ref}
              className="typo-body-1-m"
              onChange={(e) => {
                setInputValue(e.target.value);
                onChange(e);
              }}
              onBlur={onBlur}
              placeholder={placeholder}
              value={inputValue}
              autoComplete={'dsbld'}
              name={name}
              {...(maxLength ? { maxLength } : {})}
            />
          ) : (
            <input
              ref={ref}
              type={type}
              className="typo-body-1-m"
              onChange={(e) => {
                setInputValue(e.target.value);
                onChange(e);
              }}
              onBlur={onBlur}
              placeholder={placeholder}
              value={inputValue}
              autoComplete={'dsbld'}
              name={name}
              {...(maxLength ? { maxLength } : {})}
            />
          )}
          {hint && <span className="input__hint typo-body-3">{hint}</span>}
          {error && <span className="input__error typo-body-3">{error}</span>}
        </div>
      </div>
    );
  },
);
Input.displayName = 'Input';
export default Input;
