'use client';
import './index.scss';
import DatePicker from 'react-datepicker';
import { useRef, useState } from 'react';
import useClickOutside from '@/app/lib/use-outside-click';
import { formatDate } from '@/app/lib/utils';

interface IDatepicker {
  label?: string;
  error?: string;
  value?: Date;
  hint?: string;
  placeholder?: string;
  onChange?: (value: Date) => void;
}

const Datepicker = ({
  label = '',
  placeholder = '',
  error = '',
  hint,
  value,
  onChange = () => {},
}: IDatepicker) => {
  const [isOpen, setIsOpen] = useState(false);
  const [selectedDate, setSelectedDate] = useState<Date | null>(
    value ? (value instanceof Date ? value : new Date(value)) : null,
  );
  const containerRef = useRef(null);

  const handleChange = (date: Date) => {
    setSelectedDate(date);
    onChange(date);
    setIsOpen(false);
  };

  //@ts-ignore
  useClickOutside(containerRef, () => {
    if (isOpen) {
      setIsOpen(false);
    }
  });

  return (
    <div className="datepicker">
      <div className="datepicker__container">
        {label && <label className="input__label typo-body-3">{label}</label>}
        <div className="datepicker__content" ref={containerRef}>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="16"
            height="16"
            viewBox="0 0 16 16"
            fill="none"
          >
            <path
              d="M11.75 1.75H14.75C14.9489 1.75 15.1397 1.82902 15.2803 1.96967C15.421 2.11032 15.5 2.30109 15.5 2.5V14.5C15.5 14.6989 15.421 14.8897 15.2803 15.0303C15.1397 15.171 14.9489 15.25 14.75 15.25H1.25C1.05109 15.25 0.860322 15.171 0.71967 15.0303C0.579018 14.8897 0.5 14.6989 0.5 14.5V2.5C0.5 2.30109 0.579018 2.11032 0.71967 1.96967C0.860322 1.82902 1.05109 1.75 1.25 1.75H4.25V0.25H5.75V1.75H10.25V0.25H11.75V1.75ZM10.25 3.25H5.75V4.75H4.25V3.25H2V6.25H14V3.25H11.75V4.75H10.25V3.25ZM14 7.75H2V13.75H14V7.75Z"
              fill="currentColor"
            />
          </svg>
          <input
            className="datepicker__input typo-body-1-m"
            placeholder={placeholder}
            value={selectedDate ? formatDate(selectedDate as Date) : ''}
            onFocus={() => {
              setIsOpen(true);
            }}
            autoComplete="dsbld"
          />
          {isOpen && (
            <div className="datepicker__calendar">
              <DatePicker
                selected={selectedDate}
                minDate={new Date()}
                //@ts-ignore
                onChange={(date, e) => {
                  e?.preventDefault();
                  e?.stopPropagation();
                  date && handleChange(date);
                }}
                // showTimeSelect
                // timeIntervals={5}
                disabledKeyboardNavigation
                inline
              />
            </div>
          )}
        </div>
        {hint && <span className="datepicker__hint typo-body-3">{hint}</span>}
        {error && (
          <span className="datepicker__error typo-body-3">{error}</span>
        )}
      </div>
    </div>
  );
};

export default Datepicker;
