'use client';

import './index.scss';
import { useState } from 'react';
import React from 'react';
import Modal from '@/widgets/Modal/index';
import getLocation from '@/app/lib/get-location';
import LocationModal from '@/widgets/LocationModal';
import { sendTrackingEvent } from '@/app/lib/send-tracking-event';
import { EVENTS } from '@/app/lib/constants';

const ClientButton = ({
  trigger,
  render,
  instruction,
  formUid,
}: {
  trigger: any;
  render?: any;
  instruction: string;
  formUid: string;
}) => {
  const [showComponent, setShowComponent] = useState(false);
  const [showLocationMessage, setShowLocationMessage] = useState(false);

  return (
    <>
      {React.cloneElement(trigger, {
        onClick: (e: any) => {
          if (instruction) {
            e.preventDefault();

            switch (instruction) {
              case 'location':
                getLocation({
                  callbackSuccess: (location) => {
                    sendTrackingEvent([
                      EVENTS.TAG,
                      'location_page_view',
                      {
                        city: location.city,
                        location_name: location.title,
                      },
                    ]);
                    sendTrackingEvent([EVENTS.GO]);
                  },
                  callbackError: (er) => {
                    setShowLocationMessage(true);
                    sendTrackingEvent([
                      EVENTS.TAG,
                      'location_page_view',
                      {
                        city: '',
                        location_name: '',
                      },
                    ]);
                    sendTrackingEvent([EVENTS.GO]);
                  },
                });

                break;
              case 'form':
                if (formUid === 'test-drive') {
                  sendTrackingEvent([
                    EVENTS.TAG,
                    'cta_click',
                    {
                      button: 'Test Drive',
                    },
                  ]);
                  sendTrackingEvent([EVENTS.GO]);
                }
                setShowComponent(true);
                break;
              default:
                break;
            }
          }
        },
      })}
      {showComponent && render && (
        <Modal open={true} onClose={() => setShowComponent(false)}>
          {React.cloneElement(render, {
            modalClose: (e: any) => {
              setShowComponent(false);
            },
          })}
        </Modal>
      )}
      {showLocationMessage && (
        <Modal
          className={'location-access'}
          open={true}
          onClose={() => setShowLocationMessage(false)}
        >
          <LocationModal />
        </Modal>
      )}
    </>
  );
};

export default ClientButton;
