import { ChangeEvent, forwardRef } from 'react';
import RichText from '../RichText';
import './index.scss';

interface ICheckbox {
  label?: string;
  error?: string;
  value?: string;
  name: string;
  useMakeLinksExternal?: boolean;
  onChange?: (e: ChangeEvent<HTMLInputElement>) => void;
  onBlur?: (e: ChangeEvent<HTMLInputElement>) => void;
  onLabelClick?: (e: React.MouseEvent<HTMLElement>) => void;
}

const Checkbox = forwardRef<HTMLInputElement, ICheckbox>(
  (
    {
      label = '',
      error = '',
      value = '',
      name,
      useMakeLinksExternal = false,
      onChange = () => {},
      onLabelClick = () => {},
      onBlur = () => {},
    },
    ref,
  ) => {
    return (
      <div className="checkbox">
        <div className="checkbox__container">
          <label className="checkbox__content" htmlFor={name}>
            <input
              ref={ref}
              type="checkbox"
              onChange={onChange}
              onBlur={onBlur}
              value={value}
              name={name}
              id={name}
            />
            <span className="checkbox__checkmark">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 14 14"
                fill="none"
              >
                <path
                  d="M1.23816 0.25H13.2382C13.4371 0.25 13.6278 0.329018 13.7685 0.46967C13.9091 0.610322 13.9882 0.801088 13.9882 1V13C13.9882 13.1989 13.9091 13.3897 13.7685 13.5303C13.6278 13.671 13.4371 13.75 13.2382 13.75H1.23816C1.03925 13.75 0.848481 13.671 0.707829 13.5303C0.567177 13.3897 0.488159 13.1989 0.488159 13V1C0.488159 0.801088 0.567177 0.610322 0.707829 0.46967C0.848481 0.329018 1.03925 0.25 1.23816 0.25ZM6.49041 10L11.7929 4.69675L10.7324 3.63625L6.49041 7.879L4.36866 5.75725L3.30816 6.81775L6.49041 10Z"
                  fill="currentColor"
                />
              </svg>
            </span>
            {label && (
              <div className="checkbox__label" onClick={onLabelClick}>
                <RichText
                  text={label}
                  useMakeLinksExternal={useMakeLinksExternal}
                />
              </div>
            )}
          </label>

          {error && (
            <span className="checkbox__error typo-body-3">{error}</span>
          )}
        </div>
      </div>
    );
  },
);
Checkbox.displayName = 'Checkbox';
export default Checkbox;
