import cn from 'classnames';
import { default as NextLink } from 'next/link';

import './index.scss';

interface IButton {
  href?: string;
  size?: 'sm' | 'lg' | 'md';
  appearance?: 'dark' | 'light' | 'transparent';
  border?: boolean;
  className?: string;
  children: React.ReactNode;
}

const Button = ({
  href,
  size = 'lg',
  appearance = 'dark',
  border = false,
  className,
  children,
  ...rest
}: IButton) => {
  const classes = cn([
    'button',
    `button_${appearance}`,
    `button_${size}`,
    className,
    border && 'button_border',
  ]);

  return href ? (
    <NextLink href={href} className={classes} {...rest}>
      {children}
    </NextLink>
  ) : (
    <button className={classes} {...rest}>
      {children}
    </button>
  );
};

export default Button;
