import cn from 'classnames';
import './index.scss';

const AspectRatio = ({
  className,
  children,
  width,
  height,
  mobileWidth = width,
  mobileHeight = height,
}: {
  className?: string;
  children: React.ReactNode;
  width: number;
  height: number;
  mobileWidth?: number;
  mobileHeight?: number;
}) => {
  return (
    <div
      className={cn('aspect-ratio', className)}
      style={
        {
          '--media-width': width,
          '--media-height': height,
          '--media-width-mobile': mobileWidth,
          '--media-height-mobile': mobileHeight,
        } as React.CSSProperties
      }
    >
      {children}
    </div>
  );
};

export default AspectRatio;
