import { Arrow } from '@icons';
import cn from 'classnames';
import NextLink from 'next/link';

import './index.scss';

interface IArrowLink {
  href?: string;
  className?: string;
  children: React.ReactNode;
  download?: boolean;
  likeTextWithArrow?: boolean;
}

const ArrowLink = ({
  href,
  className,
  children,
  download,
  likeTextWithArrow,
  ...rest
}: IArrowLink) => {
  const classes = cn(['arrow-link', className]);

  if (download) {
    return (
      <a
        className={classes}
        href={href}
        target="_blank"
        rel="noopener noreferrer"
        download
      >
        {children}{' '}
        <svg
          width="24"
          height="25"
          viewBox="0 0 24 25"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className="arrow-link__icon"
        >
          <path
            d="M5.25 17.7119H18.75V19.2119H5.25V17.7119ZM12.75 13.3409L17.3032 8.78691L18.3638 9.84741L12 16.2119L5.63625 9.84816L6.69675 8.78691L11.25 13.3394V4.96191H12.75V13.3409Z"
            fill="currentColor"
          />
        </svg>
      </a>
    );
  }

  return href ? (
    <NextLink href={href} className={classes} {...rest}>
      {children} {href && Arrow}
    </NextLink>
  ) : likeTextWithArrow ? (
    <span className={classes} {...rest}>
      {children} {Arrow}
    </span>
  ) : (
    <button className={classes} {...rest}>
      {children} {href && Arrow}
    </button>
  );
};

export default ArrowLink;
