'use client';
import { DATA_SECTION_TITLE, EVENTS } from '@/app/lib/constants';
import { sendTrackingEvent } from '@/app/lib/send-tracking-event';
import { usePathname, useSearchParams } from 'next/navigation';
import { useEffect, useRef } from 'react';

const TimeOnSection = () => {
  const pathname = usePathname();
  const params = useSearchParams();

  const resetTimer = () => {
    if (window.currentSection) {
      const curtime = new Date().getTime();

      sendTrackingEvent([
        EVENTS.TAG,
        'scroll_depth',
        {
          ...window.currentSection,
          time_spent: (curtime - window.currentSection.time_spent) / 1000,
        },
      ]);
      sendTrackingEvent([EVENTS.GO]);
    }
  };

  const startTracking = (sectionTitle: string) => {
    resetTimer();

    window.currentSection = {
      time_spent: new Date().getTime(),
      section_title: sectionTitle,
      page_title: document.title,
      page_url: window.location.href,
    };
  };

  useEffect(() => {
    window.observerDelay = null;
    window.currentSection = null;

    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            const internalSectionTitle = (entry.target as HTMLElement).dataset
              .sectionTitle!;

            if (internalSectionTitle) {
              startTracking(internalSectionTitle);
            } else {
              resetTimer();
            }
          }
        });
      },
      {
        threshold: 0.1,
      },
    );

    window.observerDelay = setTimeout(() => {
      document.body
        .querySelectorAll(
          `section, .news [${DATA_SECTION_TITLE}], .offers [${DATA_SECTION_TITLE}]`,
        )
        .forEach((section) => {
          observer.observe(section);
        });
    }, 300);

    return () => {
      resetTimer();
      window.currentSection = null;
      window.observerDelay = null;
      observer.disconnect();
    };
  }, [pathname, params]);

  return <></>;
};

export default TimeOnSection;
