'use client';
import { EVENTS } from '@/app/lib/constants';
import { sendTrackingEvent } from '@/app/lib/send-tracking-event';
import { usePathname, useSearchParams } from 'next/navigation';
import { useEffect } from 'react';

const TimeOnPage = () => {
  const pathname = usePathname();
  const params = useSearchParams();

  const resetTimer = () => {
    if (window.currentPage) {
      const curtime = new Date().getTime();
      const timeSpent = (curtime - window.currentPage.time_spent) / 1000;

      if (timeSpent === 0) return;
      sendTrackingEvent([
        EVENTS.TAG,
        'time_on_page',
        {
          ...window.currentPage,
          time_spent: timeSpent,
        },
      ]);
      sendTrackingEvent([EVENTS.GO]);
    }
  };

  const startTracking = () => {
    resetTimer();

    if (!window.currentPage) {
      window.currentPage = {
        time_spent: new Date().getTime(),
        page_title: document.title,
        page_url: window.location.href,
      };
    }
  };

  useEffect(() => {
    window.currentPage = null;

    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            startTracking();
          }
        });
      },
      {
        threshold: 0.1,
      },
    );

    document.body
      .querySelectorAll(
        `section, .news .offers-card:nth-child(even), .offers .offers-card:nth-child(even)`,
      )
      .forEach((section) => {
        observer.observe(section);
      });

    return () => {
      resetTimer();

      window.currentPage = null;
      observer.disconnect();
    };
  }, [pathname, params]);

  return <></>;
};

export default TimeOnPage;
