'use client';

import Button from '@/shared/ui/Button';
import { useParams } from 'next/navigation';
import { useEffect, useState } from 'react';
import styles from '../Notifications/modal.module.scss';
import cn from 'classnames';
import { CUSTOMER_ID } from '@/app/constants/common';

const translates = {
  ar: {
    title:
      'لا تفوّت كل جديد، فقط اختر "السماح" لتلقّي آخر الإشعارات والتحديثات.',
    denyButton: 'عدم السماح',
    allowButton: 'السماح',
  },
  en: {
    title:
      "Don't miss out on Latest Updates. Just press 'Allow' to get relevant Push Notifications.",
    denyButton: 'Deny',
    allowButton: 'Allow',
  },
};

const PREFERENCE_KEY = 'notificationPreference';
const PREFERENCE_DENIED_KEY = 'denied';
const PREFERENCE_GRANTED_KEY = 'granted';

const ServiceWorkerRegister = () => {
  const params = useParams();
  //@ts-ignore
  const translate = translates[params?.lang] || translates.en;
  const [showModal, setShowModal] = useState(false);

  const getNotificationPreference = () => {
    return localStorage.getItem(PREFERENCE_KEY);
  };

  const loadWorker = async () => {
    if (!window.WebEmarsysSdk) return;
    navigator.serviceWorker
      .register('/service-worker.js')
      .then(async () => {
        if (!(await window.WebEmarsysSdk?.isSubscribed())) {
          setShowModal(true);
        }
      })
      .catch((e) => {
        console.error('Service Worker registration failed:', e);
      });
  };

  const isSafari = () => {
    return (
      navigator.userAgent.indexOf('Safari') > -1 &&
      navigator.userAgent.indexOf('Chrome') <= -1 &&
      navigator.userAgent.indexOf('CriOS') <= -1 &&
      navigator.userAgent.indexOf('FxiOS') <= -1
    );
  };

  useEffect(() => {
    window.addEventListener('loadedEmarsys', () => {
      if (!window.WebEmarsysSdk) {
        return;
      }

      const generatedId = localStorage.getItem(CUSTOMER_ID);
      window.WebEmarsysSdk.login({
        fieldId: 14292, // Internal ID of the customer in Emarsys
        fieldValue: generatedId,
      });
      console.log('Web Push login', generatedId);
    });

    if (getNotificationPreference() === PREFERENCE_DENIED_KEY) return;
    if (isSafari()) return;
    if (!('serviceWorker' in navigator)) return;

    window.addEventListener('loadedEmarsys', loadWorker);
  }, []);

  return (
    <>
      {showModal && (
        <div className={styles['notification-modal']}>
          <div className={styles['notification-modal__container']}>
            <div className={styles['notification-modal__text']}>
              <span
                className={cn(
                  styles['notification-modal__title'],
                  'typo-body-1',
                )}
              >
                {translate.title}
              </span>
            </div>
            <div className={styles['notification-modal__buttons']}>
              <Button
                appearance="dark"
                className={styles['notification-modal__button']}
                {...{
                  onClick: () => {
                    localStorage.setItem(PREFERENCE_KEY, PREFERENCE_DENIED_KEY);
                    setShowModal(false);
                  },
                }}
              >
                <span className="typo-link-big">{translate.denyButton}</span>
              </Button>
              <Button
                border
                appearance="light"
                className={styles['notification-modal__button']}
                {...{
                  onClick: async () => {
                    try {
                      await window.WebEmarsysSdk?.subscribe();

                      window.WebEmarsysSdk?.push([
                        'onPermissionDenied',
                        () => {
                          localStorage.setItem(
                            PREFERENCE_KEY,
                            PREFERENCE_DENIED_KEY,
                          );
                          setShowModal(false);
                        },
                      ]);
                      window.WebEmarsysSdk?.push([
                        'onPermissionGranted',
                        () => {
                          localStorage.setItem(
                            PREFERENCE_KEY,
                            PREFERENCE_GRANTED_KEY,
                          );

                          setShowModal(false);
                        },
                      ]);
                    } catch (e) {}
                  },
                }}
              >
                <span className="typo-link-big">{translate.allowButton}</span>
              </Button>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default ServiceWorkerRegister;
