'use client';

import { CUSTOMER_ID } from '@/app/constants/common';
import { useEffect } from 'react';

const CustomerId = () => {
  function generateUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(
      /[xy]/g,
      function (c) {
        const r = (Math.random() * 16) | 0;
        const v = c === 'x' ? r : (r & 0x3) | 0x8;
        return v.toString(16);
      },
    );
  }
  function getOrCreateUniqueIdentifier() {
    let uniqueId = localStorage.getItem(CUSTOMER_ID);
    if (!uniqueId) {
      uniqueId = generateUUID();
      localStorage.setItem(CUSTOMER_ID, uniqueId);
    }
    return uniqueId;
  }

  useEffect(() => {
    getOrCreateUniqueIdentifier();
  }, []);

  return <></>;
};

export default CustomerId;
