'use client';
import Button from '@/shared/ui/Button';
import { useParams } from 'next/navigation';
import { useEffect, useState } from 'react';
import styles from '../Notifications/modal.module.scss';
import cn from 'classnames';

const translates = {
  ar: {
    title:
      'نستخدم خدمة ملفات تعريف الارتباط من طرف ثالث لتطوير خدماتنا والمحتوى وتحليل حركة الشبكة. <a target="_blank" href="/ar/privacy-policy">لمعرفة المزيد، انقر هنا.</a>',
    denyButton: 'غير موافق',
    allowButton: 'موافق',
  },
  en: {
    title:
      'We use third-party cookies to personalize content, ads, and analyze traffic. <a target="_blank" href="/en/privacy-policy">Learn more</a>',
    denyButton: 'Decline',
    allowButton: 'Allow cookies',
  },
};

const Cookie = () => {
  const params = useParams();
  //@ts-ignore
  const translate = translates[params?.lang] || translates.en;
  const [show, setShow] = useState(false);

  useEffect(() => {
    setTimeout(() => {
      if (document.cookie.indexOf('onedersaccepted_cookies=') < 0) {
        setShow(true);
      }
    }, 0);
  }, []);

  return (
    <>
      {show && (
        <div className={styles['notification-modal']}>
          <div className={styles['notification-modal__container']}>
            <div className={styles['notification-modal__text']}>
              <span
                className={cn(
                  styles['notification-modal__title'],
                  'typo-body-1',
                )}
                dangerouslySetInnerHTML={{ __html: translate.title }}
              ></span>
            </div>
            <div className={styles['notification-modal__buttons']}>
              <Button
                appearance="dark"
                className={styles['notification-modal__button']}
                {...{
                  onClick: () => {
                    document.cookie = 'onedersaccepted_cookies=no;';
                    setShow(false);
                  },
                }}
              >
                <span className="typo-link-big">{translate.denyButton}</span>
              </Button>
              <Button
                border
                appearance="light"
                className={styles['notification-modal__button']}
                {...{
                  onClick: () => {
                    document.cookie = 'onedersaccepted_cookies=yes;';
                    setShow(false);
                  },
                }}
              >
                <span className="typo-link-big">{translate.allowButton}</span>
              </Button>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default Cookie;
