export function getStrapiURL() {
  return `${process.env.NEXT_PUBLIC_STRAPI_HOST}`;
}

export function getStrapiCdnUrl() {
  return `${
    process.env.NEXT_PUBLIC_STRAPI_CDN_HOST ||
    process.env.NEXT_PUBLIC_STRAPI_HOST
  }`;
}

export function getStrapiMedia(url: string | null) {
  if (url == null) return null;
  if (url.startsWith('data:')) return url;
  if (url.startsWith('http') || url.startsWith('//')) return url;
  return `${getStrapiCdnUrl()}${url}`;
}

export async function getPublicStrapiContent({ url }: { url: string }) {
  const reqOptions = {
    headers: {
      Authorization: `Bearer ${process.env.NEXT_PUBLIC_STRAPI_API_TOKEN}`,
    },
  };

  const req = await fetch(`${getStrapiURL()}${url}`, reqOptions);
  return await req.json();
}

export async function getStrapiContent({ url }: { url: string }) {
  const reqOptions = {
    headers: {
      Authorization: `Bearer ${process.env.STRAPI_API_TOKEN}`,
    },
  };

  const req = await fetch(`${getStrapiURL()}${url}`, reqOptions);
  return await req.json();
}

export async function getStrapiForm({
  formUid,
  lang,
}: {
  formUid: string;
  lang: string;
}) {
  const req = await getStrapiContent({
    url: `/api/form/find-by-uid/${formUid}?locale=${lang}&populate=deep&publicationState=live`,
  });

  return req;
}

export const formatTime = (timestamp: string) => {
  const date = new Date(timestamp);

  const day = String(date.getUTCDate()).padStart(2, '0');
  const month = String(date.getUTCMonth() + 1).padStart(2, '0');
  const year = String(date.getUTCFullYear()).slice(-2);

  return `${day}.${month}.${year}`;
};

// export const formatDate = (date: Date) => {
//   const month = new Intl.DateTimeFormat('en-US', { month: 'long' }).format(
//     date,
//   );

//   const day = date.getDate();

//   const year = date.getFullYear();

//   let hours = date.getHours();
//   const ampm = hours >= 12 ? 'PM' : 'AM';
//   hours = hours % 12;
//   hours = hours ? hours : 12;

//   const minutes = date.getMinutes();
//   const formattedMinutes = minutes < 10 ? '0' + minutes : minutes;

//   const formattedDate = `${month} ${day}, ${year} ${hours}:${formattedMinutes} ${ampm}`;

//   return formattedDate;
// };

export const formatDate = (dateString: Date) => {
  const date = new Date(dateString);

  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, '0');
  const day = String(date.getDate()).padStart(2, '0');

  const formattedDate = `${year}-${month}-${day}`;
  return formattedDate;
};
