import { CUSTOMER_ID } from '@/app/constants/common';
import { EVENTS } from './constants';

export const sendTrackingEvent = (params: any[]): void => {
  if (
    [
      EVENTS.TAG,
      EVENTS.VIEW,
      EVENTS.SEARCH_TERM,
      EVENTS.SET_CUSTOMER_ID,
    ].includes(params?.[0]) &&
    process.env.NEXT_PUBLIC_EVENT_ENDPOINT_URL
  ) {
    try {
      const generatedId = localStorage.getItem(CUSTOMER_ID);

      if (!generatedId) {
        throw new Error("Customer id isn't generated");
      }

      const name = params[1];
      const data = params[2];

      const payload = {
        name,
        customer_id: generatedId,
        eventDate: new Date().toISOString(),
        data,
      };

      fetch(process.env.NEXT_PUBLIC_EVENT_ENDPOINT_URL, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(payload),
      });
    } catch (e) {
      console.log(e);
    }
  }

  (window as any).ScarabQueue = (window as any).ScarabQueue || [];
  (window as any).ScarabQueue.push(params);
};
