import { getStrapiContent } from './utils';

export const notFoundHandler = ({ data, url, locales, lang }: any) => {
  return new Promise<void | string>(async (resolve, reject) => {
    if (data?.error?.status === 404) {
      const anotherLocale = locales.find((locale: string) => locale !== lang);

      if (anotherLocale) {
        const pg = await getStrapiContent({
          url: `${url}?locale=${anotherLocale}&publicationState=live`,
        });

        if (pg?.error?.status === 404) {
          reject(`/${lang}/not-found`);
        } else {
          reject(`/${anotherLocale}`);
        }
      } else {
        reject(`/${lang}/not-found`);
      }
    }

    resolve();
  });
};
