import { PAGENAME_KEY } from './constants';
import { notFoundHandler } from './not-found-handler';
import { getStrapiContent } from './utils';

interface PageContent {
  result?: any[];
  redirectPage?: string;
}

const getPageContent = ({
  url,
  callbackUrl,
  locales,
  lang,
  pageName,
}: {
  url: string;
  callbackUrl: string;
  locales: string[];
  lang: string;
  pageName?: string;
}) => {
  return new Promise<PageContent>(async (resolve) => {
    return getStrapiContent({
      url: `/api/global?locale=${lang}&populate=deep`,
    })
      .then(async (globalData) => {
        let replaceForPageNameKey = pageName || '';
        let notFoundCallbackUrl = callbackUrl;
        let pageUrl = url;

        const homePage = globalData.data.attributes.homePage?.data;

        if (homePage) {
          const { locale, slug: homePageSlug } = homePage.attributes;

          if (pageName === '/') {
            replaceForPageNameKey = homePageSlug;
          } else if (pageName === homePageSlug) {
            resolve({ redirectPage: `/${locale}` });
          }
        } else {
          //TODO remove it after it will be merged into master
          if (pageName === '/') {
            replaceForPageNameKey = 'home-page';
          } else if (pageName === 'home-page') {
            resolve({ redirectPage: `/${lang}` });
          }
        }

        if (replaceForPageNameKey) {
          pageUrl = pageUrl.replace(PAGENAME_KEY, replaceForPageNameKey);
          notFoundCallbackUrl = notFoundCallbackUrl.replace(
            PAGENAME_KEY,
            replaceForPageNameKey,
          );
        }

        const page = await getStrapiContent({
          url: pageUrl,
        });

        return { page, globalData, notFoundCallbackUrl };
      })
      .then(async ({ page, globalData, notFoundCallbackUrl }) => {
        await notFoundHandler({
          data: page,
          url: notFoundCallbackUrl,
          lang,
          locales,
        });

        return { page, globalData };
      })
      .then(async ({ page, globalData }) => {
        const modelsData = await getStrapiContent({
          url: `/api/products?locale=${lang}&populate[0]=CarouselData&populate[1]=CarouselImage&sort[0]=sortOrder`,
        });

        resolve({ result: [page, globalData, modelsData] });
      })
      .catch((res) => {
        resolve({ redirectPage: res });
      });
  });
};

export default getPageContent;
