export const getOAuth2Token = async (tokenUrl: string, clientId: string, clientSecret: string):Promise<string> => {
  const params = new URLSearchParams();
  params.append('grant_type', 'client_credentials');

  const credentials = btoa(`${clientId}:${clientSecret}`);

  const response = await fetch(tokenUrl, {
    method: 'POST',
    headers: {
      'Authorization': `Basic ${credentials}`,
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    body: params.toString(),
  });

  const data = await response.json();

  console.log('*** getOAuth2Token', {
    tokenUrl,
    clientId,
    clientSecret,
    response,
    data,
  });

  if (!response.ok) {
    throw new Error('Request failed');
  }

  return data.access_token;
};
