interface ILocation {
  lat: number;
  long: number;
  url: string;
  title: string;
  city: string;
}

const locations: ILocation[] = [
  {
    title: 'Sulaymaniyah',
    city: 'Riyadh',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D9%85%D9%83%D8%A9+%D8%A7%D9%84%D9%85%D9%83%D8%B1%D9%85%D8%A9+%D8%A7%D9%84%D9%83%D8%B9%D9%83%D9%8A%D8%A9%E2%80%AD/@21.3617271,39.7951365,19z/data=!4m14!1m7!3m6!1s0x15c3cd648fbeffb1:0xac2274955744db6f!2z2LTZitix2Yog2LPZhtin2KjZhCDYp9mE2K3Yr9mK2KvYqSAo2LXYp9mE2Kkg2LnYsdi2KSDYp9mE2LPZhNmK2YXYp9mG2YrYqSDYrNiv2Kk!8m2!3d21.5141575!4d39.2400343!16s%2Fg%2F11ptngnny2!3m5!1s0x15c21116089ff1f9:0x2b050fce2b0a9583!8m2!3d21.3617029!4d39.7950742!16s%2Fg%2F11kc0dkkrd?entry=ttu',
    lat: 24.709475767668142,
    long: 46.70680227116444,
  },
  {
    title: 'Khurais',
    city: 'Riyadh',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D8%A7%D9%84%D8%B1%D9%8A%D8%A7%D8%B6+%D8%AE%D8%B1%D9%8A%D8%B5%E2%80%AD/@24.7506671,46.8191707,19z/data=!4m6!3m5!1s0x3e2f01d2bf52f68f:0xdc102aa5721c70cd!8m2!3d24.7508352!4d46.8190634!16s%2Fg%2F11smzt79r5?entry=ttu',
    lat: 24.750846234807987,
    long: 46.81905945804186,
  },
  {
    title: 'Automall',
    city: 'Jeddah',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D8%A3%D9%88%D8%AA%D9%88%D9%85%D9%88%D9%84+%D8%AC%D8%AF%D8%A9%E2%80%AD/@21.6483841,39.1140216,19z/data=!4m6!3m5!1s0x15c3d9a88e3c6a03:0xebfcfd70ace8e140!8m2!3d21.648265!4d39.1140932!16s%2Fg%2F11p76p4br9?entry=ttu',
    lat: 21.648282053267053,
    long: 39.11408772628022,
  },
  {
    title: 'Sulaimaniah',
    city: 'Jeddah',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D8%A7%D9%84%D8%B3%D9%84%D9%8A%D9%85%D8%A7%D9%86%D9%8A%D8%A9+%D8%AC%D8%AF%D8%A9%E2%80%AD/@21.5141636,39.2400365,19z/data=!4m6!3m5!1s0x15c3cd648fbeffb1:0xac2274955744db6f!8m2!3d21.5141575!4d39.2400343!16s%2Fg%2F11ptngnny2?entry=ttu',
    lat: 21.514163593324078,
    long: 39.240036466590546,
  },
  {
    title: 'Khobar',
    city: 'Dammam',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D8%A7%D9%84%D8%AF%D9%85%D8%A7%D9%85%E2%80%AD/@26.3685986,50.177847,19z/data=!4m14!1m7!3m6!1s0x15c3cd648fbeffb1:0xac2274955744db6f!2z2LTZitix2Yog2LPZhtin2KjZhCDYp9mE2K3Yr9mK2KvYqSAo2LXYp9mE2Kkg2LnYsdi2KSDYp9mE2LPZhNmK2YXYp9mG2YrYqSDYrNiv2Kk!8m2!3d21.5141575!4d39.2400343!16s%2Fg%2F11ptngnny2!3m5!1s0x3e49e5c942c8668b:0xaf89f0b2c6a9777a!8m2!3d26.3686255!4d50.1778446!16s%2Fg%2F11rnfx2v_k?entry=ttu',
    lat: 26.36863643644301,
    long: 50.177844810779426,
  },
  {
    title: 'Modern Chery Sanabel (showroom)',
    city: 'Madinah',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D8%A7%D9%84%D9%85%D8%AF%D9%8A%D9%86%D8%A9+%D8%A7%D9%84%D9%85%D9%86%D9%88%D8%B1%D8%A9%E2%80%AD/@24.4987608,39.6469095,19z/data=!4m14!1m7!3m6!1s0x15c3cd648fbeffb1:0xac2274955744db6f!2z2LTZitix2Yog2LPZhtin2KjZhCDYp9mE2K3Yr9mK2KvYqSAo2LXYp9mE2Kkg2LnYsdi2KSDYp9mE2LPZhNmK2YXYp9mG2YrYqSDYrNiv2Kk!8m2!3d21.5141575!4d39.2400343!16s%2Fg%2F11ptngnny2!3m5!1s0x15bdbf8926667a77:0x636f5dd7d2603641!8m2!3d24.4987239!4d39.6469318!16s%2Fg%2F11swnb48s3?entry=ttu',
    lat: 24.498735614048332,
    long: 39.6469336599341,
  },
  {
    title: 'Modern Chery Sanabel (showroom)',
    city: 'Makkah',
    url: 'https://www.google.com/maps/place/%D8%B4%D9%8A%D8%B1%D9%8A+%D8%B3%D9%86%D8%A7%D8%A8%D9%84+%D8%A7%D9%84%D8%AD%D8%AF%D9%8A%D8%AB%D8%A9+(%D8%B5%D8%A7%D9%84%D8%A9+%D8%B9%D8%B1%D8%B6)+%D9%85%D9%83%D8%A9+%D8%A7%D9%84%D9%85%D9%83%D8%B1%D9%85%D8%A9+%D8%A7%D9%84%D9%83%D8%B9%D9%83%D9%8A%D8%A9%E2%80%AD/@21.3617271,39.7951365,19z/data=!4m14!1m7!3m6!1s0x15c3cd648fbeffb1:0xac2274955744db6f!2z2LTZitix2Yog2LPZhtin2KjZhCDYp9mE2K3Yr9mK2KvYqSAo2LXYp9mE2Kkg2LnYsdi2KSDYp9mE2LPZhNmK2YXYp9mG2YrYqSDYrNiv2Kk!8m2!3d21.5141575!4d39.2400343!16s%2Fg%2F11ptngnny2!3m5!1s0x15c21116089ff1f9:0x2b050fce2b0a9583!8m2!3d21.3617029!4d39.7950742!16s%2Fg%2F11kc0dkkrd?entry=ttu',
    lat: 21.361713996576672,
    long: 39.79508068901002,
  },
];

export default ({
  callbackError,
  callbackSuccess,
}: {
  callbackError: (message: string) => void;
  callbackSuccess: ({ title, city }: ILocation) => void;
}) => {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(
      (position) => {
        const userLat = position.coords.latitude;
        const userLong = position.coords.longitude;

        function findNearestLocation(
          userLat: number,
          userLong: number,
          locations: ILocation[],
        ): ILocation {
          let nearestLocation = null;
          let minDistance = Infinity;

          locations.forEach((location) => {
            const distance = getDistance(
              userLat,
              userLong,
              location.lat,
              location.long,
            );
            if (distance < minDistance) {
              minDistance = distance;
              nearestLocation = location;
            }
          });

          return nearestLocation as any;
        }

        function getDistance(
          lat1: number,
          lon1: number,
          lat2: number,
          lon2: number,
        ) {
          const R = 6371;
          const dLat = deg2rad(lat2 - lat1);
          const dLon = deg2rad(lon2 - lon1);
          const a =
            Math.sin(dLat / 2) * Math.sin(dLat / 2) +
            Math.cos(deg2rad(lat1)) *
              Math.cos(deg2rad(lat2)) *
              Math.sin(dLon / 2) *
              Math.sin(dLon / 2);
          const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
          const distance = R * c;
          return distance;
        }

        function deg2rad(deg: number) {
          return deg * (Math.PI / 180);
        }

        const nearestLocation = findNearestLocation(
          userLat,
          userLong,
          locations,
        );

        const mapLink = nearestLocation.url;
        window.open(mapLink, '_blank');
        callbackSuccess(nearestLocation);
      },
      (error) => {
        switch (error.code) {
          case error.PERMISSION_DENIED:
            return callbackError('User denied the request for Geolocation.');

          case error.POSITION_UNAVAILABLE:
            return callbackError('Location information is unavailable.');
          case error.TIMEOUT:
            return callbackError('The request to get user location timed out.');
        }
      },
    );
  } else {
    // 'Geolocation is not supported by this browser.';
  }
};
