const normalizePhone = (phone: string): string | null => {
  const numericPhone = phone.replace(/\D/g, '');

  if (/^5\d{8}$/.test(phone)) {
    return numericPhone.slice(1);
  }

  if (/^05\d{8}$/.test(phone)) {
    return numericPhone.slice(2);
  }

  if (/^9665\d{8}$/.test(phone)) {
    return numericPhone.slice(4);
  }

  return null;
};

export const formatPhoneNumber = (phone: string, format: 'local' | 'international'): string => {
  const normalizedPhone = normalizePhone(phone);

  if (!normalizedPhone) {
    return phone;
  }

  if (format === 'international') {
    return `+9665${normalizedPhone}`;
  }

  return `05${normalizedPhone}`;
};
