import { CDP_API_INTEGRATION } from './constants';

export default ({
  searchParams,
  reqData,
  lang,
}: {
  lang: string;
  searchParams: any;
  reqData: { [key: string]: string };
}) => {
  const marketing = [
    'utm_source',
    'utm_medium',
    'utm_campaign',
    'utm_term',
    'utm_content',
    'referrer_url',
    'gclid',
    'fbclid',
    'ad_platform',
    'ad_click_time',
    'leads_score',
    'cost_per_click',
    'ad_position',
    'time_spent_on_ad',
    'creative_type',
  ].reduce((acc, cur) => ({ ...acc, [cur]: searchParams?.get(cur) || '' }), {});
  console.log(reqData);

  return {
    headers: {
      'Content-Type': 'application/json',
    },
    url: CDP_API_INTEGRATION,
    data: {
      form: {
        full_name: reqData.name,
        mobile_phone: `+966${
          reqData.mobile?.startsWith('0')
            ? reqData.mobile.slice(1)
            : reqData.mobile
        }`,
        model: reqData.model,
        intent_to_buy: reqData.intent,
        city: reqData.city,
        salary_bracket: reqData.salary?.replace(/ /g, '_'),
        payment_form: reqData.payment,
        email_address: reqData.email,
        title: reqData.title,
        nationality: reqData.nationality,
        preferred_language: lang,
        unique_identifier: reqData.unique_identifier,
      },
      marketing,
    },
  };
};
